; cpu.asm
extern printf
section .data							
        fmt_no_sse	db "Ten procesor nie obsługuje SSE",10,0
        fmt_sse42	db "Ten procesor obsługuje SSE 4.2",10,0
        fmt_sse41	db "Ten procesor obsługuje SSE 4.1",10,0
        fmt_ssse3	db "Ten procesor obsługuje SSSE 3",10,0
        fmt_sse3	db "Ten procesor obsługuje SSE 3",10,0
        fmt_sse2	db "Ten procesor obsługuje SSE 2",10,0
        fmt_sse		db "Ten procesor obsługuje SSE",10,0          
section .bss
section .text							
	global main					
main:
push rbp
mov	rbp,rsp
    call cpu_sse    ;zwraca 1 w rax, jeśli procesor obsługuje SSE, w przeciwnym razie 0  
leave
ret

cpu_sse:
	push rbp
	mov rbp,rsp
    	xor r12,r12  	; flaga SSE dostępna
    	mov eax,1     	; pytamy o flagi funkcji CPU
    	cpuid 

;test for SSE
    test edx,2000000h	; testujemy bit 25 (SSE)
    jz sse2     		; SSE dostępne                  
    mov r12,1
    xor rax,rax
    mov rdi,fmt_sse
    push rcx            ; modyfikowany przez printf
    push rdx			; zachowujemy wynik cpuid
    call printf
    pop rdx
    pop rcx
sse2:
    test edx,4000000h   ; testujemy bit 26 (SSE 2)
    jz sse3            	; SSE 2 dostępne
    mov r12,1
    xor rax,rax
    mov rdi,fmt_sse2
    push rcx            ; modyfikowany przez printf
    push rdx			; zachowujemy wynik cpuid
    call printf
    pop rdx
    pop rcx
sse3:   
    test ecx,0         	; testujemy bit 0 (SSE 3)
    jz ssse3       		; SSE 3 dostępne
    mov r12,1
    xor rax,rax
    mov rdi,fmt_sse3
    push rcx            ; modyfikowany przez printf
    push rdx
	call printf
    pop rdx
	pop rcx
ssse3:   
    test ecx,9h         ; testujemy bit 9 (SSSE 3)
    jz sse41          	; SSSE 3 dostępne                 
    mov r12,1
    xor rax,rax
    mov rdi,fmt_ssse3
    push rcx            ; modyfikowany przez printf
    push rdx
	call printf
    pop rdx
	pop rcx
sse41:
    test ecx,80000h    	; testujemy bit 19 (SSE 4.1)
    jz sse42            ; SSE 4.1 dostępne
    mov r12,1
    xor rax,rax
    mov rdi,fmt_sse41 
    push rcx            ; modyfikowany przez printf
    push rdx
	call printf
    pop rdx
	pop rcx
sse42:                   
   test ecx,100000h    	; testujemy bit 20 (SSE 4.2)
   jz wrapup           	; SSE 4.2 dostępne
   mov r12,1
   xor rax,rax
   mov rdi,fmt_sse42 
   push rcx            	; modyfikowany przez printf
   push rdx
   call printf
   pop rdx
   pop rcx
wrapup:
    cmp r12,1
    je sse_ok
    mov rdi,fmt_no_sse
    xor rax,rax
    call printf         ; wyświetla komunikat, jeśli SSE niedostępne
    jmp the_exit 

sse_ok:
    mov rax,r12      	; zwraca 1, sse obsługiwane

the_exit:      

leave
ret
